<?php
require_once 'qrlib/phpqrcode/qrlib.php'; // QR library

/* -----------------------------------------
   DATABASE CONNECTIONS
----------------------------------------- */

// OLD DB (Local)
$oldDb = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
if ($oldDb->connect_error) die("Old DB failed: " . $oldDb->connect_error);

// NEW DB (Remote)
$newDb = new mysqli("srv2067.hstgr.io", "u175020854_mydbuser", "RedVertius@1221", "u175020854_mydbname");
if ($newDb->connect_error) die("Remote DB failed: " . $newDb->connect_error);


/* -----------------------------------------
   READ POST DATA
----------------------------------------- */

$cert_id           = $_POST['cert_id'];
$published_on      = $_POST['published_on'];
$qr_code_status    = $_POST['qr_code_status'];
$name              = $_POST['name'];
$person_id         = $_POST['person_id'];
$issued_on         = $_POST['issued_on'];
$valid_until       = $_POST['valid_until'];
$course_type       = $_POST['course_type'];
$model             = $_POST['model'];
$company           = $_POST['company'];
$training_location = $_POST['training_location'];
$trainer_name      = $_POST['trainer_name'];
$alignment         = $_POST['alignment'];


/* -----------------------------------------
   FUNCTIONS
----------------------------------------- */

// Generate Capital Token
function generateCapitalToken($length = 120) {
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $token = '';
    for ($i = 0; $i < $length; $i++) {
        $token .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $token;
}

// Check cert_id duplicate
function isDuplicateCertID($db, $cert_id) {
    $stmt = $db->prepare("SELECT cert_id FROM certificates WHERE cert_id = ?");
    $stmt->bind_param("s", $cert_id);
    $stmt->execute();
    $stmt->store_result();
    return ($stmt->num_rows > 0);
}

// Check token duplicate
function isDuplicateToken($db, $token) {
    $stmt = $db->prepare("SELECT token FROM certificates WHERE token = ?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->store_result();
    return ($stmt->num_rows > 0);
}


/* -----------------------------------------
   DUPLICATE CHECK BEFORE INSERT
----------------------------------------- */

// Check CERT ID
if (isDuplicateCertID($oldDb, $cert_id) || isDuplicateCertID($newDb, $cert_id)) {
    die("<h2 style='color:red;'>❌ Certificate ID already exists! Please use another CERT ID.</h2>
         <p><a href='add_certificate.php'>← Back</a></p>");
}

// Generate unique token
$token = generateCapitalToken(120);

// Check TOKEN duplicate
if (isDuplicateToken($oldDb, $token) || isDuplicateToken($newDb, $token)) {
    die("<h2 style='color:red;'>❌ Token generated is duplicate. Click submit again.</h2>
         <p><a href='add_certificate.php'>← Back</a></p>");
}

$br_code_url = "https://e-certificates.buraeuveritase.com/" . $token;


/* -----------------------------------------
   PREPARE INSERT QUERY
----------------------------------------- */

$query = "INSERT INTO certificates
(cert_id, token, published_on, qr_code_status, name, person_id, issued_on, valid_until, course_type, model, company, training_location, trainer_name, br_code_url, alignment)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

// Insert into OLD DB
$oldStmt = $oldDb->prepare($query);
$oldStmt->bind_param("sssssssssssssss",
    $cert_id, $token, $published_on, $qr_code_status, $name, $person_id,
    $issued_on, $valid_until, $course_type, $model, $company,
    $training_location, $trainer_name, $br_code_url, $alignment
);
$okOld = $oldStmt->execute();

// Insert into NEW DB
$newStmt = $newDb->prepare($query);
$newStmt->bind_param("sssssssssssssss",
    $cert_id, $token, $published_on, $qr_code_status, $name, $person_id,
    $issued_on, $valid_until, $course_type, $model, $company,
    $training_location, $trainer_name, $br_code_url, $alignment
);
$okNew = $newStmt->execute();


/* -----------------------------------------
   DISPLAY RESULT
----------------------------------------- */

if ($okOld && $okNew) {

    echo "<h2 style='color:green;'>✅ Certificate Inserted Successfully!</h2>";
    echo "<p><b>Barcode URL:</b> 
        <a href='" . htmlspecialchars($br_code_url) . "' target='_blank'>
            " . htmlspecialchars($br_code_url) . "
        </a></p>";

    // Generate QR code
    ob_start();
    QRcode::png($br_code_url, null, QR_ECLEVEL_H, 6);
    $imageString = base64_encode(ob_get_contents());
    ob_end_clean();

    echo "<p><img src='data:image/png;base64," . $imageString . "'></p>";

    echo "<p><a href='data:image/png;base64," . $imageString . "' download='certificate_qr.png'>
            <button style='padding:10px 20px;font-size:16px;background:#007bff;color:white;border:none;border-radius:6px;cursor:pointer;'>
                Download QR Code
            </button>
          </a></p>";

} else {

    echo "<h2 style='color:red;'>❌ Certificate Insert Failed</h2>";

    if (!$okOld) echo "<p>Old DB Error: " . htmlspecialchars($oldStmt->error) . "</p>";
    if (!$okNew) echo "<p>New DB Error: " . htmlspecialchars($newStmt->error) . "</p>";

    echo "<p><a href='add_certificate.php'>← Back to Add Certificate</a></p>";
}

?>
