<?php
// Updated script with search button and icon-based actions
$conn = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
require_once __DIR__ . '/auth.php';
require_admin();

// Count total certificates
$total_count = $conn->query("SELECT COUNT(*) AS total FROM certificates")->fetch_assoc()['total'];

// Search handler
$search = isset($_GET['search']) ? trim($_GET['search']) : "";

// Pagination setup (only if not searching)
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

if ($search !== "") {
    // Global search
    $search_safe = $conn->real_escape_string($search);
    $query = "
        SELECT * FROM certificates
        WHERE 
            cert_id LIKE '%$search_safe%' OR
            name LIKE '%$search_safe%' OR
            person_id LIKE '%$search_safe%' OR
            trainer_name LIKE '%$search_safe%'
        ORDER BY issued_on DESC
    ";
    $result = $conn->query($query);
    $total_pages = 1;
} else {
    $query = "SELECT * FROM certificates ORDER BY issued_on DESC LIMIT $limit OFFSET $offset";
    $result = $conn->query($query);
    $total_pages = ceil($total_count / $limit);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Certificate List</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #5b86e5, #36d1dc);
            padding: 40px;
            color: #222;
        }
        h2 {
            text-align: center;
            margin-bottom: 25px;
            font-size: 30px;
            color: white;
            text-shadow: 1px 1px 2px #000;
        }
        .buttons-top {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 5px;
        }
        a.add-btn {
            padding: 12px 18px;
            background-color: #28a745;
            color: white;
            text-align: center;
            border-radius: 6px;
            text-decoration: none;
            font-weight: bold;
            font-size: 16px;
        }
        .counter-box {
            text-align: center;
            font-size: 18px;
            color: white;
            margin-bottom: 25px;
            font-weight: bold;
            text-shadow: 1px 1px 2px #000;
        }
        .search-container {
            max-width: 900px;
            margin: 0 auto 20px;
            text-align: center;
        }
        .search-container input[type="text"] {
            width: 60%;
            padding: 12px 15px;
            font-size: 16px;
            border-radius: 8px;
            border: 1px solid #ccc;
        }
        .search-btn {
            padding: 12px 20px;
            font-size: 16px;
            border: none;
            border-radius: 8px;
            background: #007bff;
            color: white;
            cursor: pointer;
            margin-left: 5px;
        }
        .search-btn:hover {
            background: #0056b3;
        }
        table {
            width: 100%;
            max-width: 1400px;
            margin: auto;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            font-size: 14px;
        }
        th, td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #007BFF;
            color: white;
            white-space: nowrap;
        }
        tr:hover {
            background: #f7faff;
        }
        .status.validated {
            color: green;
            font-weight: bold;
        }
        .status.non-validated {
            color: red;
            font-weight: bold;
        }
        td.actions a {
            margin-right: 12px;
            font-size: 18px;
            text-decoration: none;
        }
        .edit-icon {
            color: #007bff;
        }
        .delete-icon {
            color: red;
        }
        .pagination {
            margin-top: 25px;
            text-align: center;
        }
        .pagination a {
            padding: 8px 12px;
            background: #007bff;
            color: white;
            margin: 0 5px;
            border-radius: 4px;
            text-decoration: none;
        }
        .pagination a.active {
            background: #0056b3;
        }
    </style>
</head>
<body>

<h2>All Certificates</h2>

<div class="buttons-top">
    <a class="add-btn" href="add_certificate.php">+ Add Certificate</a>
</div>

<div class="counter-box">
    Total Certificates: <?= $total_count ?>
</div>

<!-- SEARCH -->
<div class="search-container">
    <form method="GET" style="display:flex; justify-content:center; align-items:center;">
        <input type="text" name="search" placeholder="Search by ID, Name, Person ID..." value="<?= htmlspecialchars($search) ?>">
        <button class="search-btn">Search</button>
    </form>
</div>

<table>
    <thead>
        <tr>
            <th>Certificate ID</th>
            <th>Name</th>
            <th>Person ID</th>
            <th>Trainer Name</th>
            <th>Issued On</th>
            <th>Valid Until</th>
            <th>Published On</th>
            <th>QR Status</th>
            <th>Alignment</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['cert_id']) ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= htmlspecialchars($row['person_id']) ?></td>
            <td><?= htmlspecialchars($row['trainer_name']) ?></td>
            <td><?= htmlspecialchars($row['issued_on']) ?></td>
            <td><?= htmlspecialchars($row['valid_until']) ?></td>
            <td><?= htmlspecialchars($row['published_on']) ?></td>
            <td class="status <?= strtolower($row['qr_code_status']) === 'validated' ? 'validated' : 'non-validated' ?>">
                <?= htmlspecialchars($row['qr_code_status']) ?>
            </td>
            <td><?= htmlspecialchars($row['alignment']) ?></td>
            <td class="actions">
                <a href="edit_certificate.php?id=<?= urlencode($row['cert_id']) ?>" class="edit-icon">✏️</a>
                <a href="delete_certificate.php?id=<?= urlencode($row['cert_id']) ?>" class="delete-icon" onclick="return confirm('Delete this certificate?');">🗑️</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<!-- PAGINATION -->
<?php if ($search == ""): ?>
<div class="pagination">
    <?php if ($page > 1): ?><a href="?page=<?= $page - 1 ?>">&laquo; Prev</a><?php endif; ?>
    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
        <a class="<?= ($i == $page ? 'active' : '') ?>" href="?page=<?= $i ?>"><?= $i ?></a>
    <?php endfor; ?>
    <?php if ($page < $total_pages): ?><a href="?page=<?= $page + 1 ?>">Next &raquo;</a><?php endif; ?>
</div>
<?php endif; ?>

</body>
</html>
