<?php
// token_router.php

$token = $_GET['token'] ?? '';
if (!$token) {
    http_response_code(400);
    die("Missing token");
}

// DB connection
$mysqli = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
if ($mysqli->connect_error) die("DB connection failed: " . $mysqli->connect_error);

$stmt = $mysqli->prepare("SELECT * FROM certificates WHERE token = ? LIMIT 1");
if (!$stmt) die("Prepare failed: " . $mysqli->error);

$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();
$cert = $result->fetch_assoc();

if (!$cert) {
    http_response_code(404);
    echo "<h1>Certificate not found</h1>";
    echo "<p>Invalid or expired certificate link.</p>";
    exit;
}

// Get cert_id and alignment
$cert_id   = $cert['cert_id'];
$alignment = $cert['alignment'] ?? 'horizontal';

// Pass cert_id to the included file via $_GET
$_GET['cert_id'] = $cert_id;

// Include the correct verification page
if ($alignment === "vertical") {
    $redirect = "https://e-certificates.bureauveritase.com/verification.php?cert_id=" . urlencode($cert_id);
} else {
    $redirect = "https://e-certificates.bureauveritase.com/verifecation.php?cert_id=" . urlencode($cert_id);
}
header("Location: " . $redirect);
exit;
$stmt->close();
$mysqli->close();
