<?php
// verifecation.php (Horizontal Layout)
$cert_id = $_GET['cert_id'] ?? '';
if (!$cert_id) die("Certificate ID not provided");

$newDb = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
if ($newDb->connect_error) die("DB Connection failed");

$stmt = $newDb->prepare("SELECT * FROM certificates WHERE cert_id=?");
$stmt->bind_param("s", $cert_id);
$stmt->execute();
$result = $stmt->get_result();
$cert = $result->fetch_assoc();

if (!$cert) die("Certificate not found");

$name              = $cert['name'];
$course_type       = $cert['course_type'];
$model             = $cert['model'];
$company           = $cert['company'];
$training_location = $cert['training_location'];
$trainer_name      = $cert['trainer_name'];
$issued_on         = $cert['issued_on'];
$valid_until       = $cert['valid_until'];
$qr_code_url       = $cert['br_code_url'];
$pdf_file          = "certificate_" . $cert['cert_id'] . ".pdf";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Certificate Verification</title>
<style>
body { font-family: Arial; background:#eef2f7; padding:20px; }
.container { display:flex; align-items:center; justify-content:center; max-width:900px; margin:auto; background:white; padding:30px; border-radius:10px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
.info { flex:1; text-align:left; padding-right:20px;}
.qr { flex:0 0 200px; }
h2 { color:#002d9c; }
a.button { background:#002d9c; color:white; padding:10px 20px; text-decoration:none; border-radius:5px; margin-top:10px; display:inline-block;}
</style>
</head>
<body>
<div class="container">
<div class="info">
<h2>Certificate Verification</h2>
<p><strong>Name:</strong> <?php echo htmlspecialchars($name); ?></p>
<p><strong>Course:</strong> <?php echo htmlspecialchars($course_type); ?></p>
<p><strong>Model:</strong> <?php echo htmlspecialchars($model); ?></p>
<p><strong>Company:</strong> <?php echo htmlspecialchars($company); ?></p>
<p><strong>Training Location:</strong> <?php echo htmlspecialchars($training_location); ?></p>
<p><strong>Trainer:</strong> <?php echo htmlspecialchars($trainer_name); ?></p>
<p><strong>Issued On:</strong> <?php echo htmlspecialchars($issued_on); ?></p>
<p><strong>Valid Until:</strong> <?php echo htmlspecialchars($valid_until); ?></p>
<p>
    <a href="<?php echo htmlspecialchars($pdf_file); ?>" class="button" target="_blank">Download PDF</a>
    <a href="<?php echo htmlspecialchars($qr_code_url); ?>" class="button" target="_blank">Verify URL</a>
</p>
</div>
<div class="qr">
<img src="<?php echo htmlspecialchars("qrcode_" . $cert_id . ".png"); ?>" alt="QR Code" width="200">
</div>
</div>
</body>
</html>
